(sec_introduction_and_goals)=
# Einführung und Ziele


<!--
Beschreibt die wesentlichen Anforderungen und treibenden Kräfte, die bei der Umsetzung der Softwarearchitektur und Entwicklung des Systems berücksichtigt werden müssen.

Dazu gehören:

* zugrunde liegende Geschäftsziele,
* wesentliche Aufgabenstellungen,
* wesentliche funktionale Anforderungen,
* Qualitätsziele für die Architektur und
* relevante Stakeholder und deren Erwartungshaltung.
-->

(sec_problem_formulation)=
## Aufgabenstellung

<!--
.Inhalt
Kurzbeschreibung der fachlichen Aufgabenstellung, treibenden Kräfte, Extrakt (oder Abstract) der Anforderungen.
Verweis auf (hoffentlich vorliegende) Anforderungsdokumente (mit Versionsbezeichnungen und Ablageorten).

.Motivation
Aus Sicht der späteren Nutzung ist die Unterstützung einer fachlichen Aufgabe oder Verbesserung der Qualität der eigentliche Beweggrund, ein neues System zu schaffen oder ein bestehendes zu modifizieren.

.Form
Kurze textuelle Beschreibung, eventuell in tabellarischer Use-Case Form.
Sofern vorhanden, sollte die Aufgabenstellung Verweise auf die entsprechenden Anforderungsdokumente enthalten.

Halten Sie diese Auszüge so knapp wie möglich und wägen Sie Lesbarkeit und Redundanzfreiheit gegeneinander ab.
-->

```{todo}
Beschreiben der {ref}`sec_problem_formulation` mithilfe der [arc42-guideline](https://docs.arc42.org/section-1/)
```

(sec_quality_goals)=
## Qualitätsziele

<!--
.Inhalt
Die Top-3 bis Top-5 der Qualitätsanforderungen für die Architektur, deren Erfüllung oder Einhaltung den maßgeblichen Stakeholdern besonders wichtig sind.
Gemeint sind hier wirklich Qualitätsziele, die nicht unbedingt mit den Zielen des Projekts übereinstimmen.
Beachten Sie den Unterschied.

Hier ein Überblick möglicher Themen (basierend auf dem ISO 25010 Standard):

image::01_2_iso-25010-topics-DE.drawio.png["Kategorien von Qualitätsanforderungen"]

.Motivation
Weil Qualitätsziele grundlegende Architekturentscheidungen oft maßgeblich beeinflussen, sollten Sie die für Ihre Stakeholder relevanten Qualitätsziele kennen, möglichst konkret und operationalisierbar.

.Form
Tabellarische Darstellung der Qualitätsziele mit möglichst konkreten Szenarien, geordnet nach Prioritäten.
-->

(fig_iso_25010_de)=
```{drawio-figure} _figures/quality_goals_iso_25010_2023_de.drawio
:scale: 75%

Qualitätsmerkmale nach {cite:p}`ISO_25010`
```

```{todo}
Heraussuchen der {ref}`sec_quality_goals` und diese begründen, siehe [arc42-guideline](https://docs.arc42.org/section-1/)
```

Aus den neun in {numref}`fig_iso_25010_de` dargestellten wurden folgende fünf für das System herausragene Qualitätszielen identifiziert:


Qualitätsziel_a
: Begründende Beschreibung eingehend auf das System und sein Kontext.

Qualitätsziel_b
: Begründende Beschreibung eingehend auf das System und sein Kontext.

Qualitätsziel_c
: Begründende Beschreibung eingehend auf das System und sein Kontext.

Qualitätsziel_d
: Begründende Beschreibung eingehend auf das System und sein Kontext.

Qualitätsziel_e
: Begründende Beschreibung eingehend auf das System und sein Kontext.


(sec_stakeholders)=
## Stakeholders

<!--
.Inhalt
Expliziter Überblick über die Stakeholders des Systems – über alle Personen, Rollen oder Organisationen –, die

* die Architektur kennen sollten oder
* von der Architektur überzeugt werden müssen,
* mit der Architektur oder dem Code arbeiten (z.B. Schnittstellen nutzen),
* die Dokumentation der Architektur für ihre eigene Arbeit benötigen,
* Entscheidungen über das System und dessen Entwicklung treffen.

.Motivation
Sie sollten die Projektbeteiligten und -betroffenen kennen, sonst erleben Sie später im Entwicklungsprozess Überraschungen.
Diese Stakeholders bestimmen unter anderem Umfang und Detaillierungsgrad der von Ihnen zu leistenden Arbeit und Ergebnisse.

.Form
Tabelle mit Rollen- oder Personennamen, sowie deren Erwartungshaltung bezüglich der Architektur und deren Dokumentation.
-->

```{todo}
Auflisten der {ref}`sec_stakeholders` mit ihren Erwartungen, siehe [arc42-guideline](https://docs.arc42.org/section-1/)
```


| Rolle   | Kontakt/Name | Erwartungen |
| ------- | ------------ | ----------- |
| Rolle A | Kontakt/Name | Erwartungen |
| Rolle B | Kontakt/Name | Erwartungen |
| Rolle C | Kontakt/Name | Erwartungen |

